note

	description:

		"Test features of class UC_UNICODE_ROUTINES"

	test_status: "ok_to_run"
	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 2004-2005, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2019-02-05 23:54:36 +0000 (Tue, 05 Feb 2019) $"
	revision: "$Revision: 102790 $"

class UC_TEST_UNICODE_ROUTINES

inherit

	KL_TEST_CASE
	UC_IMPORTED_UNICODE_ROUTINES

create

	make_default

feature -- Tests

	test_valid_code
			-- Test code range routines.
		do
			assert ("ascii_negative", not unicode.valid_ascii_code (-1))
			assert ("ascii_positive", not unicode.valid_ascii_code (128))
			assert ("unicode_negative", not unicode.valid_code (-1))
		end

	test_ascii_string
			-- Test `is_ascii_string'.
		do
			assert ("ascii", unicode.is_ascii_string ("a"))
			assert ("not_ascii", not unicode.is_ascii_string ("%/130/"))
		end

	test_code_to_string
			-- Test `code_to_string'.
		do
			assert ("code_to_string_ascii", unicode.code_to_string (97).item (1) = 'a')
			assert ("code_to_string_unicode", unicode.code_to_string (1000).item_code (1) = 1000)
		end

end
